/**
 * event manager
 * @author sunnyjiang
 * @version 1.0
 */

var eventManager = {};
eventManager.closeConfirm = false;	// added by wilsonteng

eventManager.init = function() {
	/* 禁止文本选择 */
	document.onselectstart = document.ondragstart = function() {
		if(!event.target.id || event.target.id.indexOf('address') == -1) { // 除地址栏外不可以选择文字
			return false;
		}
	};
	
	// 屏蔽ctrl + A全选
	$(document.body).bind('keydown', function() {
		if(event.target.id == 'address-input') { // 地址栏不管
			return;
		}
		
		if(event.keyCode == 65 && event.ctrlKey) {
			event.preventDefault();
		}
	});	
	
	/*	window.onblur = function() {
		if(view.currentFocus == 'page') {
			window.onfocus = function() {
				view.setFocus2Web();
				
				// 在第一次执行完后失效
				window.onfocus = null;
			}
		}
	}*/
	
	/* 鼠标滚轮切换tab */
	window.onmousewheel = function(e) { 
		/* 鼠标hover在tab栏上才切换 */
		var target = event.target;
		
		// 找到tab-inner或者body时才结束
		while(target.tagName != 'BODY' && target.id != 'tab-inner') {
			target = target.parentNode;
		}
		if(target.id == 'tab-inner') {
			tabManager.scrollTabs(e);
		}
	};

    /* 头像按钮 */
    $('#logo-menu').click(function() {
        // browser.extension.builtin.statistics.increase();
        menuManager.showMenu('logoMenu');
    });

    $('#logon-menu').click(function() {
        // browser.extension.builtin.statistics.increase();
        menuManager.showMenu('logonMenu');
    });

    /* 右上角浏览器工具按钮 */
    $('#feedback-button').click(function() {
        // console.log('点击了反馈建议按钮');
        browser.extension.builtin.statistics.increase(STATIS_CMD_SYSBTN_FEEDBACK_CLICKED);
        tabManager.addTab('http://support.qq.com/discuss/497_1.shtml');
    });

    $('#min-button').click(function() {
        // console.log('点击了最小化按钮');
        browser.extension.builtin.statistics.increase(STATIS_CMD_SYSBTN_MINIMIZE_CLICKED);
        browser.window.minimize();
    });

    $('#max-button, #restore-button').click(function() {
        // console.log('点击了最大化/还原按钮 #' + event.currentTarget.id);
        if (event.currentTarget.id == 'max-button') {
            browser.extension.builtin.statistics.increase(STATIS_CMD_SYSBTN_MAXIMIZE_CLICKED);
        }
        else if (event.currentTarget.id == 'restore-button') {
            browser.extension.builtin.statistics.increase(STATIS_CMD_SYSBTN_RESTORE_CLICKED);
        }
        browser.window.maximize();
    });

    // added by wilson START ---------------------------------------------
    function onShowDlg(downloadCount, windowId, nRemoveAllWnds, nTabCount)
    {
        var nDialogHeight = 170;
        var bShowDlg = false;
        if (downloadCount > 0)
        {
            bShowDlg = true;
            if (nTabCount >= 2)
            {
                nDialogHeight = nDialogHeight;
            }
        }
        else if (nTabCount >= 2)
        {
            bShowDlg = true;
        }
        else
        {
            bShowDlg = false;
        }
        
        if (bShowDlg)
        {
            qqbrowser.closeconfirm.setCloseInfo(windowId, nRemoveAllWnds, nTabCount, downloadCount);
            var oParent = {};
            oParent.type = "window";
            oParent.id = windowId;
            qqbrowser.dialog.create(oParent, "aero\\closeConfirm.html", 302, nDialogHeight, true, escape('QQ浏览器关闭提醒'), true);
        }
        else
        {
            qqbrowser.window.close(windowId, nRemoveAllWnds);
        }
    }

    function onError(){
        // qqbrowser.log.info("[confirm] close_confirm: send error or timeout." + g_windowId);
        onShowDlg(0);
    }

    function getDownloadingTaskCount(windowId, nRemoveAllWnds, nTabCount){
        var obj = {};
        obj.command = "getDownloadingTaskCount";
        obj.windowId = windowId;
        try{
            qqbrowser.extension.sendRequest("{7EDBEBE6-565F-4aa2-93A1-AD250445A5B6}", obj , 
            function(reply) {
                // qqbrowser.log.info("[confirm] close_confirm: reply from download." + windowId);

                var result = eval("("+reply+")");
                var downloadCount = result[0].downloadingtaskcount;    
            
                onShowDlg(downloadCount, windowId, nRemoveAllWnds, nTabCount);
            },onError, onError);
        }
        catch(err){
        }
    }

    function onBeforeWndClosed(windowId, nRemoveAllWnds, nTabCount) {
        getDownloadingTaskCount(windowId, nRemoveAllWnds, nTabCount);
        //qqbrowser.log.info("[confirm] close_confirm: wnd close" + windowId);
    }

    function onWindowClose() {
        if (eventManager.closeConfirm) {
            onBeforeWndClosed(qqbrowser.window.currentId(), 0, tabManager.getCount())
        } else {
            browser.window.close();
        }
    } 
    // added by wilson END ---------------------------------------------

    $('#close-button').click(function() {
        // console.log('点击了关闭按钮');
        browser.extension.builtin.statistics.increase(STATIS_CMD_SYSBTN_CLOSE_CLICKED);
        // modified by wilson
        //browser.window.close();
        onWindowClose();
    });

	// 双击上方 head-top-box 或 max-event-wrapper 最大化
	$('#head-top-box').dblclick(function() {
        // 只有双击 head-top-box 或者 max-event-wrapper 才会触发最大化/还原
		if (event.target.id == 'head-top-box' || event.target.id == 'max-event-wrapper') {
			browser.window.maximize();
		}
	});

    // 主窗口处于最大化之后，点击上方标题栏实际上是点击的 tab 旁边的 tab-inner 或 tab-wrapper
    $('#tab-wrapper').dblclick(function() {
        if (event.target.id == "tab-wrapper" || event.target.id == "tab-inner") {
            browser.window.maximize();
        }
    });

	// 加入点击标题栏不影响地址栏输入的问题
/*	$('#head-top-box').mousedown(function() {
		$('#head-top-box').unbind('mouseup');
		
		if(addressbar.isFocus()) {
			$('#head-top-box').bind('mouseup', function() {
				addressbar.focus();
				addressbar.selectNoInput();
			});
		}
	}); */

	/* 淡入淡出效果 */
	$('#undo-button, #undo-list-button, #refresh-button, #stop-button, #back-button, #forward-button, #fav-button, #home-button,' + // 工具栏左边按??
		'#clean-button, #capture-button, #useful-menu-button, #sidebar-show-button, #sidebar-hide-button,' + // 工具栏右边按钮
		'#logon-menu, #logo-menu, ' + // logo按钮
		'#close-button, #max-button, #restore-button, #min-button, #menu-button, #feedback-button, ' + // 右上方按钮
		'#pagetop-button, #zoom-inner-box, #zoom-drop-button, #screen-box, #background-button, #foreground-button, #download-display , #share2weibo-button, #share2qzone-button, ' +  // 状态栏按钮
		'#downloadbar-close, '+
		'#new-tab-button').append('<span class="hover"></span>').hover(function() {
	    view.fadeButtonIn.apply(this);
	}, function() {
		var el = this;
	
		setTimeout(function() {
			if (!el.open) {
				view.fadeButtonOut.apply(el);
			}
		}, 10);
	}); 

	// TODO 使用:active伪类来代替
	/* 设置按钮按下的效果 */
	var pressedButtons = ['back-button', 'forward-button', 'refresh-button', 'home-button', 'undo-button', 'undo-list-button', 'stop-button',
	  'clean-button', 'capture-button', 'useful-menu-button', 'sidebar-hide-button', 'sidebar-show-button',
	  'logo-menu', 'logon-menu',
	  'close-button', 'min-button', 'max-button', 'restore-button', 'feedback-button', 'menu-button',
	  'address-go-button', 'engine-ie-button', 'engine-webkit-button', 'address-list-button', 
	  'pagetop-button', 'zoom-inner-box', 'zoom-drop-button', 'screen-box', 'background-button', 'foreground-button', /* 'download-display', */ 'share2weibo-button', 'share2qzone-button'];

	view.setButtonListPressed(pressedButtons);
	
	/* 工具栏按钮 */
	$('#refresh-button').click(function() {
		browser.page.reload();
		browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_REFRESH_CLICKED); //刷新上报
	});
	$('#home-button').click(function() { // 临时加入
		browser.tabs.home();
	});

	eventManager.initUndoButtons();
	
	eventManager.bindFavButton();
	
	$('#capture-button').mousedown(function() {
        /*
         * 要注意判断一下是是否是按的鼠标左键，通过 event.button 或 event.which
         * 能判断是按的哪个键
         *
         *              | 左键  中键  右键
         * -------------+-----------------
         * event.button |  0     1     2
         * event.which  |  1     2     3
         */
        if (event.button == 0) {
		    browser.skin.buttonClicked('{8A23D958-AF26-42f8-911E-04D5030CB33D}', this);
		    browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_SNAPSHOT_CLICKED);//截屏按钮上报		
        }
	});

	$('#clean-button').mousedown(function() {
        /*
         * 要注意判断一下是是否是按的鼠标左键，通过 event.button 或 event.which
         * 能判断是按的哪个键
         *
         *              | 左键  中键  右键
         * -------------+-----------------
         * event.button |  0     1     2
         * event.which  |  1     2     3
         */
        if (event.button == 0) {
		    browser.skin.buttonClicked('{510EEC09-09E9-4003-AFDD-CCB3803286C3}', this);
		    browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_EARASEHIS_CLICKED); //清除浏览痕迹上报
        }
	});

	/* 地址栏按钮 */
	$('#engine-ie-button, #engine-webkit-button').click(function() {
		browser.tabs.coreSwitch();
		browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_CORE_SWITCH_CLICKED);	//地址栏切换内核上报	
		view.setEngine(1);
	});

	$('#address-go-button').click(function() {
		addressbar.openUrl();
		browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_GOTO_CLICKED);	//地址栏转到上报		
	});

	addressbar.init();

//	$('#address-input').bind('dblclick', function() { // 双击全选
//		addressbar.selectAllInput();
//	});

	$('#address-list-button').click(function() {
		tipManager.hideTooltip();
		
		if(!addressbar.isListShown()) {	// 如果地址栏下拉显示，此时点击按钮后应该已经隐藏，设置一下状态
			addressbar.showAddresslist(); // 如果地址栏下拉不显示，显示地址栏下拉
			browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_ADDR_LIST_CLICKED);	//地址栏下拉菜单按钮上报	
		}

		$('#address-input').focus();
		return false;
	});

	// 状态栏按钮
	eventManager.bindZoomButton();
	eventManager.bindScreenButton();

/*
	// downloadbar.js
	// downloadbar
	$('#downloadbar-close').click(function() {
		view.toggleDownloadbar();
	});
*/
	$('#foreground-button').click(function() {
		// 设置为前台打开页面
		var obj = {tagsTatus: 1};	
		
		configManager.setConfig(obj);
	});

	$('#background-button').click(function() {
		// 设置为前台打开页面
		var obj = {tagsTatus: 0};	
		
		configManager.setConfig(obj);
	});	
	
	// TODO combine with view.initBorderCursor
	// drag skin
	$(document.body).bind('mousedown', function() {
		if(!event) { // 防止从tab来的事件冒泡
			return;
		}

		var element = event.target;
		var y = event.pageY;
		var x = event.pageX;
		
		var windowHeight = $(window).height();
		var windowWidth = $(window).width();
		var borderWidth = view.getSkinBorderWidth();
		
		var dragButton = $('#drag-button');
		var dragButtonWidth = dragButton.width();					

		// 小于min-width或者min-height时不处理
		var minWindowSize = layout.getMinSize();
		
		if(windowHeight <= minWindowSize.height || windowWidth < minWindowSize.width) {
			return;
		} 

		var dragType = 0;

		// 以下三个区域可以拖动
		if(element.id == 'tab-wrapper' || element.id == 'head-top-box' || element.id == 'tab-inner') // 标题栏
			dragType = 5; 
		else if(x <= borderWidth && y >= windowHeight - borderWidth) // 左下角
			dragType = 3;
		else if(y >= windowHeight - borderWidth - dragButtonWidth && x >= windowWidth - borderWidth - dragButtonWidth) // 右下角
			dragType = 4;
		else if(y <= borderWidth && x <= borderWidth) // 左上角
			dragType = 22;
		else if(y <= borderWidth && x >= windowWidth - borderWidth) // 右上角
			dragType = 23;
		else if(y <= document.getElementById("main").offsetTop) // 上边样式
			dragType = 21;	
		else if(x <= borderWidth) // 左边样式
			dragType = 12;
		else if(x >= windowWidth - borderWidth) // 右边样式
			dragType = 18;	
		else if(y >= windowHeight - borderWidth) // 下边样式
			dragType = 2;

		if(dragType != 0)
			browser.skin.dragStart(dragType);
	});

	$('#sidebar-show-button').click(function() {
		/* 保存配置
		var obj = {};
		obj[appBox._configDockShow] = 1;		
		configManager.setConfig(obj);
	
		configManager.getConfig([appBox._configName], appBox.getConfigCallback);
		$('#appbox').addClass('show');
		*/

		$('#sidebar-hide-button, #sidebar-show-button').toggle();		
		$('#sidebar-hide-button').addClass('selected');
		qqbrowser.sidebar.open();
		browser.extension.builtin.statistics.increase(STATIS_CMD_SIDEBAR_OPEN_BUTTON_CLICKED);

		
		//点侧边栏按钮，隐藏消息提醒图标，同时将总消息数置空
		$('#sidebar-new-info-float').css("visibility","hidden");
		
		/*
		var obj = {};
		obj[appBox._configSumCount] = 0;		
		configManager.setConfig(obj);
		*/
	});

	$('#sidebar-hide-button').click(function() {
		// 保存配置
		/*
		var obj = {};
		obj[appBox._configDockShow] = 0;		
		configManager.setConfig(obj);	
		*/
		
		$('#sidebar-hide-button, #sidebar-show-button').toggle();	
		qqbrowser.sidebar.close();
		$('#sidebar-new-info-float').css("visibility","hidden");			

		browser.extension.builtin.statistics.increase(STATIS_CMD_SIDEBAR_CLOSE_BUTTON_CLICKED);

	});

    // 绑定下载按钮的事件处理函数及显示效果的调整
    eventManager.bindDownloadButton();
};

eventManager.bindDownloadButton = function() {
    /*
     * view.setButtonPressed() 函数统一绑定了 button 的 mousedown 和 mouseup
     * 事件，分别在 mousedown 的时候为元素添加 "-pressed" 的类属性，
     * 而在 mouseup 的时候为元素移除 "-pressed" 的类属性，这不符合我们的要求，
     * 我们要求 button 在 mousedown 之后一直保持 pressed 状态，即 mouseup 的时候
     * 不要移除 "-pressed" 属性，而是在第二次点击 button 的时候才移除 "-pressed" 属性
     */
    // var button = $("#download-display");
    // button.attr('pressable', 'pressable');
    // return when button disabled
    // if (button.data('disabled') == 'disabled')
    // return;

    // 鼠标按下
    $("#download-display").mousedown(function() {
		view.toggleDownloadbar();
		downloadbar.removeStatusBarIconData();
        var className = $(this).attr("class");
        var index = className.indexOf("-pressed");
	    if (index == -1) {
            $(this).attr("class", className + "-pressed");       // 在尾部添加 "-pressed"
        } else {
            $(this).attr("class", className.substr(0, index));   // 截取前面一段
        }
    });
};

eventManager.initUndoButtons = function() {
	// get undo list data from browser
	browser.recentclosed.get(function(returnData) {

		var undoList = eval('(' + returnData + ')')[0];

		if((typeof undoList != 'undefined') && (undoList.length > 0)) { // have not undo list data
			eventManager.bindUndoButtons();
		} else {
			view.disableUndoButtons();
		}
	});
};

eventManager.bindUndoButtons = function() {
	$('#undo-button').click(function() {
		browser.recentclosed.undo();
		browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_LAST_CLOSE_PAGE_CLICKED);	//最近关闭按钮上报		
	});		
	$('#undo-list-button').click(function() {
		menuManager.showMenu('recentCloseMenu');
		browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_LAST_CLOSE_PAGE_LIST_CLICKED);	//最近关闭下拉按钮上报
	});
};

eventManager.bindBackButton = function() {
	$('#back-button').bind('click', function() { // add click event
		browser.page.goBack();
		browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_PAGE_BACK_CLICKED); //后退按钮上报
	});
};

eventManager.bindForwardButton = function() {
	$('#forward-button').bind('click', function() { // add click event
		browser.page.goForward();
		browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_PAGE_FORWARD_CLICKED); //前进按钮上报		
	});
};

eventManager.bindZoomButton = function() {
	$('#zoom-drop-button').click(function() {
		tipManager.hideTooltip();
		browser.skin.buttonClicked('{D21B044A-3FDF-4241-865C-5692771BED80}', this, 2);
	});

	$('#zoom-inner-box').click(function() {
		tipManager.hideTooltip();
		browser.skin.buttonClicked('{D21B044A-3FDF-4241-865C-5692771BED80}', this);
	});
};

eventManager.bindScreenButton = function() {
	$('#screen-box').unbind('mousedown'); // 解决多次调用多次绑定的问题
	
	view.setButtonPressed('screen-box'); // 恢复pressed效果
	
	$('#screen-box').mousedown(function() { // click无效，暂时用mousedown
		browser.skin.buttonClicked('{87281D86-2185-4656-BF0D-C88478545F4C}', this);
	});
};

eventManager.bindFavButton = function() {
	$('#fav-button').click(function() {
        /*
         * 要注意判断一下是是否是按的鼠标左键，通过 event.button 或 event.which
         * 能判断是按的哪个键
         *
         *              | 左键  中键  右键
         * -------------+-----------------
         * event.button |  0     1     2
         * event.which  |  1     2     3
         */
        if (event.button == 0) {
    		tipManager.hideTooltip();
    	    browser.skin.buttonClicked('{BFCEC32E-23CE-46B1-9C7E-8655F56F328C}', this);
    		browser.extension.builtin.statistics.increase(STATIS_CMD_NAVBAR_BTN_FAV_CLICKED); //收藏按钮上报
    		//$('#fav-button').addClass('fav-button-pressed');
        }
		qqbrowser.log.info("ningzhang mousedown---");
	});
};

eventManager.unbindFavButton = function() {
	$('#fav-button').unbind('click');
};
